<?php
/**
 * فال حافظ - مجموعه غزلیات حافظ با تفسیر
 */

/**
 * دریافت یک فال حافظ به صورت رندوم
 */
function getHafezFal() {
    $fals = [
        [
            'poem' => "الا یا ایها الساقی ادر کأساً و ناولها\nکه عشق آسان نمود اول ولی افتاد مشکل‌ها\n\nبه بوی نافه‌ای کاخر صبا زان طره بگشاید\nز تاب جعد مشکینش چه خون افتاد در دل‌ها",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nعزیز دل، کار تو به سامان می‌رسد ولی باید صبر داشته باشی. آنچه می‌خواهی به دست می‌آوری ولی راهش کمی طولانی است. ناامید نشو و به راهت ادامه بده.",
            'advice' => "💡 <b>پیشنهاد:</b> صبور باش و عجله نکن."
        ],
        [
            'poem' => "صلاح کار کجا و من خراب کجا\nببین تفاوت ره کز کجاست تا به کجا\n\nدلم ز صومعه بگرفت و خرقه سالوس\nکجاست دیر مغان و شراب ناب کجا",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nباید از ظاهر بگذری و به باطن توجه کنی. آنچه به دنبالش هستی در جایی است که فکرش را نمی‌کنی. چشم‌هایت را باز کن و اطرافت را خوب ببین.",
            'advice' => "💡 <b>پیشنهاد:</b> قضاوت نکن و صادق باش."
        ],
        [
            'poem' => "دل می‌رود ز دستم صاحب‌دلان خدا را\nدردا که راز پنهان خواهد شد آشکارا\n\nکشتی شکستگانیم ای باد شرطه برخیز\nباشد که بازبینیم دیدار آشنا را",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nخبرهای خوبی در راه است! کسی که دوستش داری یا منتظرش هستی به زودی خبرش می‌رسد. دلت شاد خواهد شد.",
            'advice' => "💡 <b>پیشنهاد:</b> امیدوار باش، خوشی نزدیک است."
        ],
        [
            'poem' => "اگر آن ترک شیرازی به دست آرد دل ما را\nبه خال هندویش بخشم سمرقند و بخارا را\n\nبده ساقی می باقی که در جنت نخواهی یافت\nکنار آب رکن‌آباد و گلگشت مصلا را",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nعشق و محبت در زندگیت پررنگ است. اگر دل به کسی بسته‌ای، این احساس متقابل است. قدر لحظات را بدان.",
            'advice' => "💡 <b>پیشنهاد:</b> از عشق نترس و قدمی بردار."
        ],
        [
            'poem' => "یوسف گم‌گشته بازآید به کنعان غم مخور\nکلبه احزان شود روزی گلستان غم مخور\n\nای دل غمدیده حالت به شود دل بد مکن\nوین سر شوریده بازآید به سامان غم مخور",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nغم مخور! هر چه گم کرده‌ای پیدا می‌شود. روزهای سختت تمام می‌شود و شادی از راه می‌رسد. فقط صبر کن و ایمان داشته باش.",
            'advice' => "💡 <b>پیشنهاد:</b> غصه نخور، همه چیز درست می‌شود."
        ],
        [
            'poem' => "سحر بلبل حکایت با صبا کرد\nکه عشق روی گل با ما چه‌ها کرد\n\nاز آن رنگ رخش خون در دل ما\nچکید و حسن او با ما چه‌ها کرد",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nزیبایی و لطافت در زندگیت جاری است. اتفاقات خوبی در راه است که قلبت را شاد می‌کند. به استقبال روزهای خوب برو.",
            'advice' => "💡 <b>پیشنهاد:</b> لبخند بزن، زندگی زیباست."
        ],
        [
            'poem' => "در ازل پرتو حسنت ز تجلی دم زد\nعشق پیدا شد و آتش به همه عالم زد\n\nجلوه‌ای کرد رخت دید ملک عشق نداشت\nعین آتش شد از این غیرت و بر آدم زد",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nتو از ابتدا برای بزرگی آفریده شده‌ای. استعدادهایت را جدی بگیر و به خودت ایمان داشته باش. موفقیت منتظر توست.",
            'advice' => "💡 <b>پیشنهاد:</b> به توانایی‌هایت ایمان داشته باش."
        ],
        [
            'poem' => "ما را به رندی افسانه کردند\nپیران جاهل شیخ زمانه کردند\n\nاین همه دود از کجا بلند شد\nدر خانه‌ها بازی زولانه کردند",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nمردم حرف می‌زنند ولی تو کار خودت را بکن. به حرف دیگران توجه نکن و راه خودت را برو. حق با توست.",
            'advice' => "💡 <b>پیشنهاد:</b> به حرف مردم گوش نده."
        ],
        [
            'poem' => "دوش وقت سحر از غصه نجاتم دادند\nواندر آن ظلمت شب آب حیاتم دادند\n\nبیخود از شعشعه پرتو ذاتم کردند\nباده از جام تجلی صفاتم دادند",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nنجات یافته‌ای! از سختی‌ها رها شده‌ای و روزهای روشن در انتظار توست. شکر گزار باش و قدردان.",
            'advice' => "💡 <b>پیشنهاد:</b> شکرگزار باش، بهترین‌ها در راهند."
        ],
        [
            'poem' => "ساقیا برخیز و درده جام را\nخاک بر سر کن غم ایام را\n\nساغر می بر کفم نه تا ز بر\nبرکشم این دلق ازرق فام را",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nوقت شادی است! غم و غصه را کنار بگذار و از زندگی لذت ببر. فرصت‌های خوبی پیش روی توست.",
            'advice' => "💡 <b>پیشنهاد:</b> شاد باش و از لحظات لذت ببر."
        ],
        [
            'poem' => "گفتم غم تو دارم گفتا غمت سر آید\nگفتم که ماه من شو گفتا اگر برآید\n\nگفتم ز مهرورزان رسم وفا بیاموز\nگفتا ز خوبرویان این کار کمتر آید",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nآنچه می‌خواهی به زودی به دست می‌آوری. صبور باش و منتظر بمان. زمان همه چیز را درست می‌کند.",
            'advice' => "💡 <b>پیشنهاد:</b> صبر کن، خواسته‌ات برآورده می‌شود."
        ],
        [
            'poem' => "زلف آشفته و خوی کرده و خندان لب و مست\nپیرهن چاک و غزل‌خوان و صراحی در دست\n\nنرگسش عربده‌جوی و لبش افسوس‌کنان\nنیم‌شب دوش به بالین من آمد بنشست",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nعشق به درت می‌زند! اگر منتظر کسی هستی، به زودی خبرش می‌رسد. دلت شاد خواهد شد.",
            'advice' => "💡 <b>پیشنهاد:</b> آماده خبر خوش باش."
        ],
        [
            'poem' => "روز هجران و شب فرقت یار آخر شد\nزدم این فال و گذشت اختر و کار آخر شد\n\nصبح امید که بد معتکف پرده غیب\nگو برون آی که کار شب تار آخر شد",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nروزهای سختت تمام شد! جدایی و غم به پایان رسیده و وصال نزدیک است. شادمان باش.",
            'advice' => "💡 <b>پیشنهاد:</b> تمام شد! وقت شادیست."
        ],
        [
            'poem' => "شراب تلخ می‌خواهم که مردافکن بود زورش\nکه تا یک‌دم بیاسایم ز دنیا و شر و شورش\n\nجهان پیر است و بی‌بنیاد از این فرهادکش فریاد\nکه کرد افسون و نیرنگش ملول از جان شیرینش",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nخسته شده‌ای ولی ناامید نباش. استراحت کن و دوباره شروع کن. قوی‌تر از قبل بر می‌خیزی.",
            'advice' => "💡 <b>پیشنهاد:</b> کمی استراحت کن و دوباره شروع کن."
        ],
        [
            'poem' => "به ملازمان سلطان که رساند این دعا را\nکه به شکر پادشاهی ز نظر مران گدا را\n\nز رقیب دیوسیرت به خدای خود پناهم\nمگر آن شهاب ثاقب مددی کند خدا را",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nکسی که به او نیاز داری، کمکت خواهد کرد. درخواستت پذیرفته می‌شود. با اعتماد به نفس درخواست کن.",
            'advice' => "💡 <b>پیشنهاد:</b> بخواه، به تو داده می‌شود."
        ],
        [
            'poem' => "من از آن حسن روزافزون که یوسف داشت دانستم\nکه عشق از پرده عصمت برون آرد زلیخا را\n\nاگر دشنام فرمایی وگر نفرین دعا گویم\nجواب تلخ می‌زیبد لب لعل شکرخا را",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nزیبایی و جذابیت تو باعث جلب توجه دیگران شده. مراقب باش و حواست جمع باشد ولی از این موهبت استفاده کن.",
            'advice' => "💡 <b>پیشنهاد:</b> از جذابیتت استفاده کن."
        ],
        [
            'poem' => "خدا چون صورت ابروی دلجوی تو می‌بست\nز تاب آفتاب نیز طاقش در میان بگذاشت\n\nدلم را عشق تو زآن روی خرم کرد\nکه بوی زلف تو جان مرا جان در میان بگذاشت",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nخداوند تو را با عشق آفریده است. تو مخصوصی و برای کار بزرگی خلق شده‌ای. به خودت ایمان داشته باش.",
            'advice' => "💡 <b>پیشنهاد:</b> تو خاصی، قدر خودت را بدان."
        ],
        [
            'poem' => "چو بشنوی سخن اهل دل مگو که خطاست\nسخن شناس نه‌ای جان من خطا این‌جاست\n\nسرم به دنیی و عقبی فرو نمی‌آید\nتبارک الله از این فتنه‌ها که در سر ماست",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nبه حرف دلت گوش بده نه مردم. تو راه درست را می‌دانی، فقط باید به آن عمل کنی.",
            'advice' => "💡 <b>پیشنهاد:</b> به قلبت گوش بده."
        ],
        [
            'poem' => "تو بدی طالع من در همه احوال ای مه\nکار بد مصلحت آن‌است که تدبیر کنم\n\nگفتم اشک من و آه سحر و سوز درون\nگفت حافظ چه گناه تو که تقدیر کنم",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nتقدیر خوبی در انتظار توست. نگران نباش، هر چه قسمت باشد خیر است. به تقدیر الهی اعتماد کن.",
            'advice' => "💡 <b>پیشنهاد:</b> توکل کن، سرنوشتت خوب است."
        ],
        [
            'poem' => "هزار جهد بکردم که یار من باشی\nمراد حاصل نشد که کامکار من باشی\n\nکنون که بی‌تو به سر می‌برم سری دارم\nعجب که بعد از این غمگسار من باشی",
            'meaning' => "🔮 <b>تفسیر فال:</b>\n\nتلاش‌هایت به نتیجه می‌رسد ولی کمی صبر لازم است. آن‌که می‌خواهی به سمتت می‌آید.",
            'advice' => "💡 <b>پیشنهاد:</b> ادامه بده، نتیجه می‌گیری."
        ]
    ];
    
    // انتخاب یک فال رندوم
    $randomIndex = array_rand($fals);
    return $fals[$randomIndex];
}

/**
 * فرمت کردن فال برای ارسال
 */
function formatHafezFal() {
    $fal = getHafezFal();
    
    $message = "📜 <b>فـال حـافـظ</b> 📜\n";
    $message .= "━━━━━━━━━━━━━━━\n\n";
    $message .= "<i>" . $fal['poem'] . "</i>\n\n";
    $message .= "━━━━━━━━━━━━━━━\n\n";
    $message .= $fal['meaning'] . "\n\n";
    $message .= $fal['advice'] . "\n\n";
    $message .= "━━━━━━━━━━━━━━━\n";
    $message .= "🕯 با نیت پاک فال گرفتید";
    
    return $message;
}
